<?php $__env->startSection('content'); ?>

<nav class="dsdsd" aria-label="breadcrumb">
    <div class="container">
        <ol class="breadcrumb custom-breadcrumb">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Blinds</a></li>
            <li class="breadcrumb-item active" aria-current="page">Wooden</li>
        </ol>
    </div>
</nav>


<!-- Luxury Section -->
<section class="luxury-section">
    <div class="container">
        <div class="row align-items-center ewewe">

            <!-- Left Content -->
            <div class="col-lg-8 luxury-content">
                <h2>Wooden Blinds</h2>
                <p>
                    Relax in total luxury with made-to-measure wooden blinds from <strong>Blinds Market</strong>.
                    Exquisite from every angle, our premium wooden slatted window blinds are the perfect finishing touch
                    to your home’s interior.
                    Whether you’re looking for blinds for your
                    <a href="#">bedroom</a> or <a href="#">bathroom</a>,
                    <a href="#">living room blinds</a> or <a href="#">kitchen blinds</a>,
                    <strong>Blinds Market</strong> wooden Venetian blinds provide the privacy and comfort you need
                    without making any compromises on style.
                </p>


                <!-- Buttons -->
                <div>
                    <button class="luxury-btn">Real Wooden Blinds</button>
                    <button class="luxury-btn">Faux Wooden Blinds</button>
                    <button class="luxury-btn">White Wooden Blinds</button>
                    <button class="luxury-btn">Next Day Delivery Blinds</button>
                </div>
            </div>

            <!-- Right Image -->
            <div class="col-lg-4 luxury-image mt-4 mt-lg-0">
                <img src="https://www.swiftdirectblinds.co.uk/media/wysiwyg/plp/kitchen_plp.jpg" alt="Wooden Blinds" />
            </div>

        </div>
    </div>
</section>

<style>
/* Product Type Buttons */
.product-type-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 10px;
}

.product-type-list li {
    display: flex;
}

.type-btn {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    text-decoration: none;
    padding: 10px 14px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 14px;
    color: #333;
    background: #fff;
    transition: all 0.3s ease;
}

.type-btn span {
    color: #777;
    font-size: 13px;
}

.type-btn:hover,
.type-btn.active {
    background: #f8f9fa;
    border-color: #007bff;
    color: #007bff;
    transform: translateY(-2px);
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.08);
}
</style>
<section class="flat-spacing-24">
    <div class="container">
        <div class="row">
            <div class="col-xl-3">
                <div class="canvas-sidebar sidebar-filter canvas-filter left">
                    <div class="canvas-wrapper">
                        <div class="canvas-header d-flex d-xl-none">
                            <span class="title">Filter</span>
                            <span class="icon-close icon-close-popup close-filter"></span>
                        </div>
                        <div class="canvas-body">

                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#productType"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="productType">
                                    <span>Categories</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="productType" class="collapse show">
                                    <ul class="collapse-body product-type-list">
                                        <li>
                                            <a href="<?php echo e(route('products')); ?>" class="type-btn <?php echo e(!request('category') ? 'active' : ''); ?>">
                                                All Products 
                                                <span>(<?php echo e(\App\Models\Product::where('is_active', 1)->count()); ?>)</span>
                                            </a>
                                        </li>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('products', ['category' => $category->id])); ?>" 
                                                   class="type-btn <?php echo e(request('category') == $category->id ? 'active' : ''); ?>">
                                                    <?php echo e($category->name); ?> 
                                                    <span>(<?php echo e($category->products()->where('is_active', 1)->count()); ?>)</span>
                                                </a>
                                            </li>
                                            <?php if($category->children->count() > 0): ?>
                                                <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li style="margin-left: 20px;">
                                                        <a href="<?php echo e(route('products', ['category' => $child->id])); ?>" 
                                                           class="type-btn <?php echo e(request('category') == $child->id ? 'active' : ''); ?>">
                                                            <?php echo e($child->name); ?> 
                                                            <span>(<?php echo e($child->products()->where('is_active', 1)->count()); ?>)</span>
                                                        </a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>


                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#availability" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="availability">
                                    <span>Pleated Type</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="availability" class="collapse show">
                                    <ul class="collapse-body filter-group-check current-scrollbar">
                                        <li class="list-item">
                                            <input type="radio" name="availability" class="tf-check" id="inStock">
                                            <label for="inStock" class="label"><span>Bottom Up</span>&nbsp;<span
                                                    class="count">(24)</span></label>
                                        </li>
                                        <li class="list-item">
                                            <input type="radio" name="availability" class="tf-check" id="outStock">
                                            <label for="outStock" class="label"><span>Top Down Bottom Up
                                                    stock</span>&nbsp;<span class="count">(11)</span></label>
                                        </li>
                                    </ul>
                                </div>
                            </div>


                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#pattern" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="pattern">
                                    <span>Pattern</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="pattern" class="collapse show">
                                    <ul class="collapse-body filter-group-check current-scrollbar">

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="plain">
                                            <label for="plain" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_plain.png"
                                                    alt="Plain" class="pattern-img me-2">
                                                <span>Plain</span>&nbsp;<span class="count">(1105)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="textured">
                                            <label for="textured" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_textured.png"
                                                    alt="Textured" class="pattern-img me-2">
                                                <span>Textured</span>&nbsp;<span class="count">(292)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="patterned">
                                            <label for="patterned" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_patterned.png"
                                                    alt="Patterned" class="pattern-img me-2">
                                                <span>Patterned</span>&nbsp;<span class="count">(201)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="floral">
                                            <label for="floral" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_floral.png"
                                                    alt="Floral" class="pattern-img me-2">
                                                <span>Floral</span>&nbsp;<span class="count">(137)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="geometric">
                                            <label for="geometric" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_geometric.png"
                                                    alt="Geometric" class="pattern-img me-2">
                                                <span>Geometric</span>&nbsp;<span class="count">(63)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="animal">
                                            <label for="animal" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_animal.png"
                                                    alt="Animal" class="pattern-img me-2">
                                                <span>Animal</span>&nbsp;<span class="count">(14)</span>
                                            </label>
                                        </li>

                                        <li class="list-item d-flex align-items-center mb-2">
                                            <input type="radio" name="pattern" class="tf-check" id="abstract">
                                            <label for="abstract" class="label d-flex align-items-center">
                                                <img src="https://www.swiftdirectblinds.co.uk/media/attribute/swatch/swatch_image/30x20/p/a/pattern_abstract.png"
                                                    alt="Abstract" class="pattern-img me-2">
                                                <span>Abstract</span>&nbsp;<span class="count">(9)</span>
                                            </label>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                            <style>
                            .pattern-img {
                                width: 28px;
                                height: 28px;
                                border-radius: 50%;
                                object-fit: cover;
                            }
                            </style>


                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#price" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="price">
                                    <span>Price</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="price" class="collapse show">
                                    <div class="collapse-body widget-price filter-price">
                                        <span class="reset-price">Reset</span>
                                        <div class="price-val-range" id="price-value-range" data-min="0" data-max="500">
                                        </div>
                                        <div class="box-value-price">
                                            <span class="text-sm">Price:</span>
                                            <div class="price-box">
                                                <div class="price-val" id="price-min-value" data-currency="$">
                                                </div>
                                                <span>-</span>
                                                <div class="price-val" id="price-max-value" data-currency="$">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#color" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="color">
                                    <span>Color</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="color" class="collapse show">
                                    <div class="collapse-body filter-color-box flat-check-list">
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-yellow"></span><span class="color-text">Yellow</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-dark"></span><span class="color-text">Black</span></div>
                                        <div class="check-item color-item color-check line"><span
                                                class="color bg-white"></span><span class="color-text">White</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-purple-3"></span><span class="color-text">Purple</span>
                                        </div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-light-orange"></span><span class="color-text">Light
                                                Orange</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-light-pink-4"></span><span class="color-text">Light
                                                Pink</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-pink"></span><span class="color-text">Pink</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-dark-green"></span><span class="color-text">Dark
                                                Green</span></div>
                                        <div class="check-item color-item color-check"><span
                                                class="color bg-grey-4"></span><span class="color-text">Grey</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#size" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="size">
                                    <span>Size</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="size" class="collapse show">
                                    <div class="collapse-body filter-size-box flat-check-list">
                                        <div class="check-item size-item size-check"><span
                                                class="size">25mm</span>&nbsp;<span class="count"> (157)</span>
                                        </div>
                                        <div class="check-item size-item size-check"><span class="size">50mm
                                            </span>&nbsp;<span class="count"> (87)</span>
                                        </div>
                                        <div class="check-item size-item size-check"><span class="size">35mm
                                            </span>&nbsp;<span class="count"> (47)</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="widget-facet">
                                <div class="facet-title text-xl fw-medium" data-bs-target="#size" role="button"
                                    data-bs-toggle="collapse" aria-expanded="true" aria-controls="size">
                                    <span>Room</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="size" class="collapse show">
                                    <div class="collapse-body filter-size-box flat-check-list">
                                        <div class="check-item size-item size-check"><span class="size">Conservatory
                                            </span>&nbsp;<span class="count">(840)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Living Room</span>&nbsp;<span class="count">(808)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Bedroom</span>&nbsp;<span class="count">(668)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Dining Room</span>&nbsp;<span class="count">(593)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Kitchen</span>&nbsp;<span class="count">(456)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Office</span>&nbsp;<span class="count">(399)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Bathroom</span>&nbsp;<span class="count">(254)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Children</span>&nbsp;<span class="count">(129)</span>
                                        </div>
                                        <div class="check-item size-item size-check">
                                            <span class="size">Nursery</span>&nbsp;<span class="count">(65)</span>
                                        </div>


                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-9">

                <div class="tf-shop-control">
                    <h4>Wooden Blinds</h4>
                    <div class="tf-group-filter">
                        <button id="filterShop" class="tf-btn-filter d-flex d-xl-none">
                            <span class="icon icon-filter"></span><span class="text">Filter</span>
                        </button>

                    </div>



                </div>

                <div class="wrapper-control-shop">

                    <div class="row g-4">
                        <?php if($products->count() > 0): ?>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="product-card">
                                        <div class="product-img">
                                            <?php if($product->primaryImage): ?>
                                                <img src="<?php echo e(asset('storage/' . $product->primaryImage->image_path)); ?>" alt="<?php echo e($product->name); ?>">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('images/no-product-image.svg')); ?>" alt="<?php echo e($product->name); ?>">
                                            <?php endif; ?>
                                            <?php if($product->discount_percentage > 0): ?>
                                                <span class="discount-badge"><?php echo e($product->discount_percentage); ?>% OFF</span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="product-body">
                                            <?php if($product->is_featured): ?>
                                                <span class="delivery-tag">Featured</span>
                                            <?php endif; ?>
                                            <h5 class="product-title"><?php echo e($product->name); ?></h5>
                                            <p class="product-sub"><?php echo e($product->brand->name ?? 'No Brand'); ?>, <?php echo e($product->category->name ?? 'No Category'); ?></p>
                                            <p>
                                                <span class="price">From £<?php echo e(number_format($product->price, 2)); ?></span>
                                                <?php if($product->discount_percentage > 0): ?>
                                                    <span class="old-price">£<?php echo e(number_format($product->price / (1 - $product->discount_percentage / 100), 2)); ?></span>
                                                <?php endif; ?>
                                            </p>
                                            <button class="sample-btn" onclick="window.location.href='<?php echo e(route('product.detail', $product->id)); ?>'">
                                                View Product
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="text-center py-5">
                                    <h4>No products found</h4>
                                    <p class="text-muted">Try adjusting your search criteria or browse all products.</p>
                                    <a href="<?php echo e(route('products')); ?>" class="btn btn-primary">View All Products</a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Pagination -->
                    <?php if($products->hasPages()): ?>
                        <div class="mt-4">
                            <?php echo e($products->appends(request()->query())->links('pagination::bootstrap-4')); ?>

                        </div>
                    <?php endif; ?>


                </div>
            </div>
        </div>
    </div>
</section>





<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/decora/resources/views/pages/products.blade.php ENDPATH**/ ?>