<?php $__env->startSection('content'); ?>
    <section class="flat-spacing-3">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1 class="page-title">Shopping Cart</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Cart</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="flat-spacing-3">
        <div class="container">
            <div class="row">
                <!-- Cart Items -->
                <div class="col-lg-8">
                    <div class="cart-items-container">
                        <div class="cart-header d-none d-md-flex">
                            <div class="row">
                                <div class="col-md-6"><h5>Product</h5></div>
                                <div class="col-md-2 text-center"><h5>Price</h5></div>
                                <div class="col-md-2 text-center"><h5>Quantity</h5></div>
                                <div class="col-md-2 text-end"><h5>Total</h5></div>
                            </div>
                        </div>
                        
                        <!-- Cart Item 1 -->
                        <div class="cart-item">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center">
                                        <div class="cart-item-image me-3">
                                            <img src="<?php echo e(asset('assets/img/memento (1).jpg')); ?>" alt="Roller Blind" class="img-fluid" style="max-width: 100px;">
                                        </div>
                                        <div class="cart-item-details">
                                            <h5 class="cart-item-title">Premium Roller Blind</h5>
                                            <p class="cart-item-variant mb-0">Color: White | Size: 120cm x 150cm</p>
                                            <button class="btn btn-link text-danger p-0 mt-2 remove-item">
                                                <i class="fa-solid fa-trash-can"></i> Remove
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center"><span>£24.99</span></div>
                                <div class="col-md-2 text-center">
                                    <div class="quantity-selector d-flex align-items-center justify-content-center">
                                        <button class="btn btn-sm btn-outline-secondary quantity-btn">-</button>
                                        <input type="number" class="form-control form-control-sm text-center mx-2" value="1" min="1" max="10" style="width: 50px;">
                                        <button class="btn btn-sm btn-outline-secondary quantity-btn">+</button>
                                    </div>
                                </div>
                                <div class="col-md-2 text-end"><span>£24.99</span></div>
                            </div>
                        </div>
                        
                        <!-- Cart Item 2 -->
                        <div class="cart-item">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-center">
                                        <div class="cart-item-image me-3">
                                            <img src="<?php echo e(asset('assets/img/premier_bright_white.webp')); ?>" alt="Venetian Blind" class="img-fluid" style="max-width: 100px;">
                                        </div>
                                        <div class="cart-item-details">
                                            <h5 class="cart-item-title">Aluminum Venetian Blind</h5>
                                            <p class="cart-item-variant mb-0">Color: Silver | Size: 90cm x 120cm</p>
                                            <button class="btn btn-link text-danger p-0 mt-2 remove-item">
                                                <i class="fa-solid fa-trash-can"></i> Remove
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center"><span>£32.50</span></div>
                                <div class="col-md-2 text-center">
                                    <div class="quantity-selector d-flex align-items-center justify-content-center">
                                        <button class="btn btn-sm btn-outline-secondary quantity-btn">-</button>
                                        <input type="number" class="form-control form-control-sm text-center mx-2" value="2" min="1" max="10" style="width: 50px;">
                                        <button class="btn btn-sm btn-outline-secondary quantity-btn">+</button>
                                    </div>
                                </div>
                                <div class="col-md-2 text-end"><span>£65.00</span></div>
                            </div>
                        </div>
                        
                        <!-- Empty Cart Message -->
                        <div class="empty-cart text-center py-5 d-none">
                            <i class="fa-solid fa-cart-shopping fa-4x mb-3 text-muted"></i>
                            <h4>Your cart is empty</h4>
                            <p>Looks like you haven't added any items to your cart yet.</p>
                            <a href="<?php echo e(route('products')); ?>" class="btn btn-primary mt-3">Continue Shopping</a>
                        </div>
                        
                        <!-- Cart Actions -->
                        <div class="cart-actions d-flex justify-content-between mt-4">
                            <a href="<?php echo e(route('products')); ?>" class="btn btn-outline-secondary">
                                <i class="fa-solid fa-arrow-left me-2"></i>Continue Shopping
                            </a>
                            <button class="btn btn-outline-danger">
                                <i class="fa-solid fa-trash-can me-2"></i>Clear Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Order Summary -->
                <div class="col-lg-4 mt-4 mt-lg-0">
                    <div class="cart-summary card">
                        <div class="card-header bg-transparent">
                            <h4 class="mb-0">Order Summary</h4>
                        </div>
                        <div class="card-body">
                            <div class="summary-item d-flex justify-content-between mb-2"><span>Subtotal</span><span>£89.99</span></div>
                            <div class="summary-item d-flex justify-content-between mb-2"><span>Shipping</span><span>£4.99</span></div>
                            <div class="summary-item d-flex justify-content-between mb-2"><span>Tax</span><span>£18.00</span></div>
                            <hr>
                            <div class="summary-item d-flex justify-content-between mb-3"><strong>Total</strong><strong>£112.98</strong></div>
                            
                            <!-- Coupon Code -->
                            <div class="coupon-section mb-3">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Coupon code">
                                    <button class="btn btn-outline-secondary" type="button">Apply</button>
                                </div>
                            </div>
                            
                            <a href="<?php echo e(route('checkout')); ?>" class="btn btn-primary w-100">Proceed to Checkout</a>
                            
                            <!-- Payment Methods -->
                            <div class="payment-methods mt-3 text-center">
                                <p class="text-muted small mb-2">We Accept</p>
                                <div class="payment-icons">
                                    <i class="fa-brands fa-cc-visa mx-1"></i>
                                    <i class="fa-brands fa-cc-mastercard mx-1"></i>
                                    <i class="fa-brands fa-cc-amex mx-1"></i>
                                    <i class="fa-brands fa-cc-paypal mx-1"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Shipping Policy -->
                    <div class="shipping-policy mt-4">
                        <h5>Shipping & Returns</h5>
                        <ul class="list-unstyled">
                            <li><i class="fa-solid fa-truck me-2"></i> Free shipping on orders over £100</li>
                            <li><i class="fa-solid fa-rotate-left me-2"></i> 30-day return policy</li>
                            <li><i class="fa-solid fa-shield me-2"></i> Secure checkout</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/decora/resources/views/pages/cart.blade.php ENDPATH**/ ?>