<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    ProductController, BrandController, CategoryController, ProductImageController,
    OfferController, CouponController, CartController, OrderController,
    SliderController, TestimonialController, VariantController,
    AddressController, WishlistController, AttributeController
};

/*
| Public routes
*/
Route::get('products', [ProductController::class,'index']);
Route::get('products/{id}', [ProductController::class,'show']);
Route::get('brands', [BrandController::class,'index']);
Route::get('categories', [CategoryController::class,'index']);
Route::get('sliders', [SliderController::class,'index']);
Route::get('testimonials', [TestimonialController::class,'index']);
Route::get('attributes', [AttributeController::class,'index']);

// coupon validation
Route::post('coupon/validate', [CouponController::class,'validateCode']);

/*
| Protected routes (require token via Sanctum)
*/
Route::middleware('auth:sanctum')->group(function(){
    // product management
    Route::apiResource('products', ProductController::class)->except(['index','show']);
    Route::post('product-images', [ProductImageController::class,'store']);
    Route::delete('product-images/{id}', [ProductImageController::class,'destroy']);

    // brands, categories
    Route::apiResource('brands', BrandController::class)->except(['index']);
    Route::apiResource('categories', CategoryController::class)->except(['index','show']);

    // offers & coupons
    Route::apiResource('offers', OfferController::class);
    Route::apiResource('coupons', CouponController::class)->except(['create','edit']);

    // cart & orders
    Route::get('cart', [CartController::class,'index']);
    Route::post('cart', [CartController::class,'store']);
    Route::put('cart/{id}', [CartController::class,'update']);
    Route::delete('cart/{id}', [CartController::class,'destroy']);

    Route::get('orders', [OrderController::class,'index']);
    Route::get('orders/{id}', [OrderController::class,'show']);
    Route::post('orders', [OrderController::class,'store']);

    // wishlist
    Route::get('wishlist', [WishlistController::class,'index']);
    Route::post('wishlist', [WishlistController::class,'store']);
    Route::delete('wishlist/{id}', [WishlistController::class,'destroy']);

    // address
    Route::apiResource('addresses', AddressController::class)->only(['index','store','update','destroy']);

    // slider/testimonial/variant
    Route::apiResource('sliders', SliderController::class);
    Route::apiResource('testimonials', TestimonialController::class)->only(['store','index']);
    Route::get('products/{productId}/variants', [VariantController::class,'index']);
    Route::post('variants', [VariantController::class,'store']);
    Route::delete('variants/{id}', [VariantController::class,'destroy']);

    // attributes
    Route::post('attributes', [AttributeController::class,'store']);
    Route::post('attributes/{id}/values', [AttributeController::class,'storeValue']);

});
