@extends('layouts.app')

@section('content')

<nav class="dsdsd" aria-label="breadcrumb">
    <div class="container">
        <ol class="breadcrumb custom-breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('products') }}">Products</a></li>
            <li class="breadcrumb-item active" aria-current="page">Product Details</li>
        </ol>
    </div>
</nav>

<br><br>

@php
    // Handle both single product and multiple products scenarios
    $productList = isset($product) ? collect([$product]) : $products;
@endphp

@if($productList->count() > 0)
    @foreach($productList as $index => $product)
    <section class="flat-single-product {{ $index > 0 ? 'mt-5' : '' }}">
        <div class="tf-main-product section-image-zoom">
            <div class="container">
                <div class="row">
                    <!-- Product Images -->
                    <div class="col-md-7">
                        <div class="tf-product-media-wrap sticky-top">
                            <div class="product-thumbs-slider">
                                <div dir="ltr" class="swiper tf-product-media-thumbs other-image-zoom" data-preview="4" data-direction="vertical">
                                    <div class="swiper-wrapper stagger-wrap">
                                        @if($product->images->count() > 0)
                                            @foreach($product->images as $image)
                                            <div class="swiper-slide stagger-item">
                                                <div class="item">
                                                    <img class="lazyload"
                                                        data-src="{{ asset('storage/' . $image->image_path) }}"
                                                        src="{{ asset('storage/' . $image->image_path) }}"
                                                        alt="{{ $product->name }}">
                                                </div>
                                            </div>
                                            @endforeach
                                        @else
                                            <div class="swiper-slide stagger-item">
                                                <div class="item">
                                                    <img class="lazyload"
                                                        data-src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                        src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                        alt="{{ $product->name }}">
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <div dir="ltr" class="swiper tf-product-media-main" id="gallery-swiper-started">
                                    <div class="swiper-wrapper">
                                        @if($product->images->count() > 0)
                                            @foreach($product->images as $image)
                                            <div class="swiper-slide">
                                                <a href="{{ asset('storage/' . $image->image_path) }}" target="_blank" class="item" data-pswp-width="552px" data-pswp-height="827px">
                                                    <img class="tf-image-zoom lazyload"
                                                        data-zoom="{{ asset('storage/' . $image->image_path) }}"
                                                        data-src="{{ asset('storage/' . $image->image_path) }}"
                                                        src="{{ asset('storage/' . $image->image_path) }}"
                                                        alt="{{ $product->name }}">
                                                </a>
                                            </div>
                                            @endforeach
                                        @else
                                            <div class="swiper-slide">
                                                <a href="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}" target="_blank" class="item" data-pswp-width="552px" data-pswp-height="827px">
                                                    <img class="tf-image-zoom lazyload"
                                                        data-zoom="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                        data-src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                        src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}"
                                                        alt="{{ $product->name }}">
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="swiper-button-next nav-swiper thumbs-next"></div>
                                    <div class="swiper-button-prev nav-swiper thumbs-prev"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /Product Images -->

                    <!-- Product Info -->
                    <div class="col-md-5">
                        <div class="tf-zoom-main"></div>
                        <div class="tf-product-info-wrap other-image-zoom">
                            <div class="tf-product-info-list">
                                <div class="tf-product-heading">
                                    <span class="brand-product">{{ $product->brand->name ?? 'Blinds' }}</span>
                                    <h5 class="product-name fw-medium">{{ $product->name }}</h5>
                                    <div class="product-rate">
                                        <div class="list-star">
                                            @php
                                                $avgRating = $product->averageRating();
                                                $fullStars = floor($avgRating);
                                                $hasHalfStar = ($avgRating - $fullStars) >= 0.5;
                                            @endphp
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= $fullStars)
                                                    <i class="icon icon-star"></i>
                                                @elseif($i == $fullStars + 1 && $hasHalfStar)
                                                    <i class="icon icon-star-half"></i>
                                                @else
                                                    <i class="icon icon-star-o"></i>
                                                @endif
                                            @endfor
                                        </div>
                                        <span class="count-review">({{ $product->totalReviews() }} reviews)</span>
                                    </div>
                                    <div class="product-price">
                                        @if($product->sale_price && $product->sale_price < $product->price)
                                            <div class="display-sm price-new price-on-sale">£{{ number_format($product->sale_price, 2) }}</div>
                                            <div class="display-sm price-old">£{{ number_format($product->price, 2) }}</div>
                                            @php
                                                $discount = round((($product->price - $product->sale_price) / $product->price) * 100);
                                            @endphp
                                            <span class="badge-sale">{{ $discount }}% Off</span>
                                        @else
                                            <div class="display-sm price-new">£{{ number_format($product->price, 2) }}</div>
                                        @endif
                                    </div>
                                </div>

                                <div class="product-description">
                                    <p>{{ $product->description ?? 'High-quality blinds perfect for any room.' }}</p>
                                </div>

                                <div class="install-form">
                                    <div class="install-title">Select an Installation Method</div>
                                    <div class="d-flex gap-3 mb-3">
                                        <div class="col install-option" id="recessOption">
                                            Recess
                                        </div>
                                        <div class="col install-option active" id="exactOption">
                                            Exact
                                        </div>
                                    </div>

                                    <div class="install-title">Enter Your Measurements</div>
                                    <div class="mb-3">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="unit_{{ $product->id }}" id="cmUnit_{{ $product->id }}" checked>
                                            <label class="form-check-label" for="cmUnit_{{ $product->id }}">Centimeters</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="unit_{{ $product->id }}" id="mmUnit_{{ $product->id }}">
                                            <label class="form-check-label" for="mmUnit_{{ $product->id }}">Millimetres</label>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label for="width_{{ $product->id }}" class="form-label">Width</label>
                                            <input type="number" class="form-control" id="width_{{ $product->id }}" placeholder="Enter width">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="height_{{ $product->id }}" class="form-label">Height</label>
                                            <input type="number" class="form-control" id="height_{{ $product->id }}" placeholder="Enter height">
                                        </div>
                                    </div>

                                    <div class="tf-product-info-quantity">
                                        <div class="quantity-title fw-6">Quantity</div>
                                        <div class="wg-quantity">
                                            <span class="btn-quantity minus-btn">-</span>
                                            <input type="text" name="number" value="1">
                                            <span class="btn-quantity plus-btn">+</span>
                                        </div>
                                    </div>

                                    <div class="tf-product-info-buy-button">
                                        <form class="">
                                            <a href="javascript:void(0);" class="tf-btn btn-fill justify-content-center fw-6 fs-16 flex-grow-1 animate-hover-btn">
                                                <span>Add to cart - £{{ number_format($product->sale_price ?? $product->price, 2) }}</span>
                                            </a>
                                            <div class="tf-product-btn-wishlist btn-icon-action">
                                                <i class="icon-heart"></i>
                                                <i class="icon-delete"></i>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /Product Info -->
                </div>
            </div>
        </div>
    </section>

    @if($product->reviews->count() > 0)
    <section class="flat-spacing-3">
        <div class="container">
            <div class="flat-title">
                <h4 class="title">Customer Reviews for {{ $product->name }}</h4>
            </div>
            <div class="row">
                @foreach($product->reviews->take(3) as $review)
                <div class="col-md-4 mb-4">
                    <div class="review-card">
                        <div class="review-top">
                            <div class="review-stars">
                                @for($i = 1; $i <= 5; $i++)
                                    @if($i <= $review->rating)
                                        <i class="fa-solid fa-star"></i>
                                    @else
                                        <i class="fa-regular fa-star"></i>
                                    @endif
                                @endfor
                            </div>
                            @if($review->is_verified)
                                <div class="review-verified">Verified</div>
                            @endif
                        </div>
                        <div class="review-title">{{ $review->title }}</div>
                        <div class="review-text">{{ $review->comment }}</div>
                        <div class="review-footer">
                            <span class="review-customer">{{ $review->user->name ?? 'Anonymous' }},</span> 
                            {{ $review->created_at->diffForHumans() }}
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif
    @endforeach
@else
    <section class="flat-spacing-3">
        <div class="container">
            <div class="text-center">
                <h3>No Products Found</h3>
                <p>No products match your criteria. Please try different filters.</p>
                <a href="{{ route('products') }}" class="tf-btn btn-fill">View All Products</a>
            </div>
        </div>
    </section>
@endif

@endsection
