@extends('layouts.app')

@section('content')
    @include('components.slider')

    <section class="flat-spacing-3 ">
        <div class="container">
            <div class="feature-strip">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="feature-item feature-express active">
                            <i class="fa-solid fa-truck feature-icon"></i>
                            <div class="feature-title">Express Shutters</div>
                            <div class="feature-text">Delivered in 7 working days</div>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="feature-item feature-trustpilot active">
                            <i class="fa-solid fa-star feature-icon"></i>
                            <div class="feature-title">Rated Excellent on Trustpilot</div>
                            <div class="feature-text">with over 5,000 reviews</div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="feature-item feature-uk active">
                            <i class="fa-solid fa-industry feature-icon"></i>
                            <div class="feature-title">Proudly Made in the UK</div>
                            <div class="feature-text">on thousands of products</div>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="feature-item feature-delivery active">
                            <i class="fa-solid fa-bolt feature-icon"></i>
                            <div class="feature-title">Fast Next Day Delivery</div>
                            <div class="feature-text">Available on selected items</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="flat-spacing-3">
        <div class="container">
            <div class="flat-title wow fadeInUp">
                <h4 class="title ">Custom Blinds & Curtains, Perfectly Fitted for You</h4>
            </div>
            <div class="hover-sw-nav wow fadeInUp">
                <div dir="ltr" class="swiper tf-swiper wrap-sw-over" data-swiper='{
                        "slidesPerView": 1, 
                        "spaceBetween": 12,
                        "speed": 800,
                        "observer": true,
                        "observeParents": true,
                        "slidesPerGroup": 1,
                        "navigation": {
                            "clickable": true,
                            "nextEl": ".nav-next-seller",
                            "prevEl": ".nav-prev-seller"
                        },
                        "pagination": { "el": ".sw-pagination-seller", "clickable": true },
                        "breakpoints": {
                            "768": { "slidesPerView": 3, "spaceBetween": 12, "slidesPerGroup": 3 },
                            "1200": { "slidesPerView": 4, "spaceBetween": 24, "slidesPerGroup": 4 }
                        }
                    }'>
                    <div class="swiper-wrapper">

                        <div class="swiper-slide">
                            <div class="card-product card-product-size">
                                <div class="card promo-card">
                                    <!-- Image Section -->
                                    <div class="promo-img">
                                        <img src="https://www.swiftdirectblinds.co.uk/media/wysiwyg/homepage/blinds/Swift-SBC-352x400-Wooden_Blinds.jpg"
                                            alt="Summer Sale">
                                    </div>
                                    <!-- Content Section -->
                                    <div class="card-body text-center promo-body">
                                        <h5 class="card-title">Summer Sale</h5>
                                        <p class="card-text">Huge summer savings on blinds designed for style,
                                            comfort, and quality.</p>
                                        <a href="{{ route('products') }}" class="btn promo-btn">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="card-product card-product-size">
                                <div class="card promo-card">
                                    <!-- Image Section -->
                                    <div class="promo-img">
                                        <img src="{{ asset('assets/img/memento (1).jpg') }}" alt="Roller Blinds">
                                    </div>
                                    <!-- Content Section -->
                                    <div class="card-body text-center promo-body">
                                        <h5 class="card-title">Roller Blinds</h5>
                                        <p class="card-text">Versatile, practical, and stylish window coverings for any room.</p>
                                        <a href="{{ route('products') }}" class="btn promo-btn">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="card-product card-product-size">
                                <div class="card promo-card">
                                    <!-- Image Section -->
                                    <div class="promo-img">
                                        <img src="{{ asset('assets/img/premier_bright_white.webp') }}" alt="Venetian Blinds">
                                    </div>
                                    <!-- Content Section -->
                                    <div class="card-body text-center promo-body">
                                        <h5 class="card-title">Venetian Blinds</h5>
                                        <p class="card-text">Classic slatted blinds offering precise light control and privacy.</p>
                                        <a href="{{ route('products') }}" class="btn promo-btn">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="card-product card-product-size">
                                <div class="card promo-card">
                                    <!-- Image Section -->
                                    <div class="promo-img">
                                        <img src="{{ asset('assets/img/zafira-spice.png') }}" alt="Roman Blinds">
                                    </div>
                                    <!-- Content Section -->
                                    <div class="card-body text-center promo-body">
                                        <h5 class="card-title">Roman Blinds</h5>
                                        <p class="card-text">Elegant fabric blinds that fold neatly when raised.</p>
                                        <a href="{{ route('products') }}" class="btn promo-btn">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="card-product card-product-size">
                                <div class="card promo-card">
                                    <!-- Image Section -->
                                    <div class="promo-img">
                                        <img src="{{ asset('assets/img/Voiles-resized.png') }}" alt="Curtains & Voiles">
                                    </div>
                                    <!-- Content Section -->
                                    <div class="card-body text-center promo-body">
                                        <h5 class="card-title">Curtains & Voiles</h5>
                                        <p class="card-text">Beautiful drapes and sheer fabrics for a soft window treatment.</p>
                                        <a href="{{ route('products') }}" class="btn promo-btn">Shop Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="swiper-pagination sw-pagination-seller"></div>
                </div>
                <div class="swiper-button-next nav-next-seller"></div>
                <div class="swiper-button-prev nav-prev-seller"></div>
            </div>
        </div>
    </section>

    <section class="flat-spacing-3">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="category-banner">
                        <img src="{{ asset('assets/img/blind-systems.jpg') }}" alt="Blinds Systems" class="img-fluid">
                        <div class="category-content">
                            <h3>Blind Systems</h3>
                            <p>Innovative solutions for modern homes</p>
                            <a href="{{ route('products') }}" class="btn btn-outline-light">Explore</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="category-banner">
                        <img src="{{ asset('assets/img/grey_blackout_roller_fully_closed_-_bedroom_23_.png') }}" alt="Blackout Solutions" class="img-fluid">
                        <div class="category-content">
                            <h3>Blackout Solutions</h3>
                            <p>Perfect for bedrooms and media rooms</p>
                            <a href="{{ route('products') }}" class="btn btn-outline-light">Discover</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection