@extends('layouts.app')

@section('content')
    <section class="flat-spacing-3">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1 class="page-title">Checkout</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('cart') }}">Cart</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="flat-spacing-3">
        <div class="container">
            <form id="checkout-form">
                <div class="row">
                    <div class="col-lg-8">
                        <!-- Checkout Steps -->
                        <div class="checkout-steps mb-4">
                            <div class="row">
                                <div class="col-4 text-center">
                                    <div class="step active">
                                        <div class="step-number">1</div>
                                        <div class="step-title">Shipping</div>
                                    </div>
                                </div>
                                <div class="col-4 text-center">
                                    <div class="step">
                                        <div class="step-number">2</div>
                                        <div class="step-title">Payment</div>
                                    </div>
                                </div>
                                <div class="col-4 text-center">
                                    <div class="step">
                                        <div class="step-number">3</div>
                                        <div class="step-title">Confirmation</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Shipping Information -->
                        <div class="checkout-section mb-4" id="shipping-section">
                            <div class="card">
                                <div class="card-header bg-transparent">
                                    <h4 class="mb-0">Shipping Information</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="firstName" class="form-label">First Name*</label>
                                            <input type="text" class="form-control" id="firstName" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="lastName" class="form-label">Last Name*</label>
                                            <input type="text" class="form-control" id="lastName" required>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email Address*</label>
                                        <input type="email" class="form-control" id="email" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="phone" class="form-label">Phone Number*</label>
                                        <input type="tel" class="form-control" id="phone" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="address" class="form-label">Address Line 1*</label>
                                        <input type="text" class="form-control" id="address" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="address2" class="form-label">Address Line 2</label>
                                        <input type="text" class="form-control" id="address2">
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="city" class="form-label">City*</label>
                                            <input type="text" class="form-control" id="city" required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="postcode" class="form-label">Postcode*</label>
                                            <input type="text" class="form-control" id="postcode" required>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="country" class="form-label">Country*</label>
                                        <select class="form-select" id="country" required>
                                            <option value="">Select Country</option>
                                            <option value="UK" selected>United Kingdom</option>
                                            <option value="US">United States</option>
                                            <option value="CA">Canada</option>
                                            <option value="AU">Australia</option>
                                            <option value="DE">Germany</option>
                                            <option value="FR">France</option>
                                        </select>
                                    </div>
                                    
                                    <div class="mb-3 form-check">
                                        <input type="checkbox" class="form-check-input" id="saveAddress">
                                        <label class="form-check-label" for="saveAddress">Save this address for future orders</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Shipping Method -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header bg-transparent">
                                    <h4 class="mb-0">Shipping Method</h4>
                                </div>
                                <div class="card-body">
                                    <div class="shipping-options">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="shippingMethod" id="standardShipping" value="standard" checked>
                                            <label class="form-check-label d-flex justify-content-between align-items-center w-100" for="standardShipping">
                                                <div>
                                                    <strong>Standard Delivery</strong>
                                                    <p class="text-muted mb-0">Delivery within 3-5 working days</p>
                                                </div>
                                                <span>£4.99</span>
                                            </label>
                                        </div>
                                        
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="shippingMethod" id="expressShipping" value="express">
                                            <label class="form-check-label d-flex justify-content-between align-items-center w-100" for="expressShipping">
                                                <div>
                                                    <strong>Express Delivery</strong>
                                                    <p class="text-muted mb-0">Delivery within 1-2 working days</p>
                                                </div>
                                                <span>£8.99</span>
                                            </label>
                                        </div>
                                        
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="shippingMethod" id="nextDayShipping" value="nextDay">
                                            <label class="form-check-label d-flex justify-content-between align-items-center w-100" for="nextDayShipping">
                                                <div>
                                                    <strong>Next Day Delivery</strong>
                                                    <p class="text-muted mb-0">Order before 2pm for next working day delivery</p>
                                                </div>
                                                <span>£12.99</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Payment Method (Initially Hidden) -->
                        <div class="checkout-section mb-4 d-none" id="payment-section">
                            <div class="card">
                                <div class="card-header bg-transparent">
                                    <h4 class="mb-0">Payment Method</h4>
                                </div>
                                <div class="card-body">
                                    <div class="payment-options">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="paymentMethod" id="creditCard" value="creditCard" checked>
                                            <label class="form-check-label" for="creditCard">
                                                <strong>Credit/Debit Card</strong>
                                                <div class="payment-icons mt-1">
                                                    <i class="fa-brands fa-cc-visa me-1"></i>
                                                    <i class="fa-brands fa-cc-mastercard me-1"></i>
                                                    <i class="fa-brands fa-cc-amex me-1"></i>
                                                </div>
                                            </label>
                                        </div>
                                        
                                        <div id="creditCardForm" class="payment-form mb-4">
                                            <div class="mb-3">
                                                <label for="cardName" class="form-label">Name on Card*</label>
                                                <input type="text" class="form-control" id="cardName" required>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <label for="cardNumber" class="form-label">Card Number*</label>
                                                <input type="text" class="form-control" id="cardNumber" placeholder="XXXX XXXX XXXX XXXX" required>
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="expiryDate" class="form-label">Expiry Date*</label>
                                                    <input type="text" class="form-control" id="expiryDate" placeholder="MM/YY" required>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <label for="cvv" class="form-label">CVV*</label>
                                                    <input type="text" class="form-control" id="cvv" placeholder="123" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="paymentMethod" id="paypal" value="paypal">
                                            <label class="form-check-label" for="paypal">
                                                <strong>PayPal</strong>
                                                <i class="fa-brands fa-paypal ms-2"></i>
                                            </label>
                                        </div>
                                        
                                        <div id="paypalForm" class="payment-form mb-4 d-none">
                                            <p>You will be redirected to PayPal to complete your payment.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Order Notes -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header bg-transparent">
                                    <h4 class="mb-0">Order Notes</h4>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label for="orderNotes" class="form-label">Special instructions for your order (optional)</label>
                                        <textarea class="form-control" id="orderNotes" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Navigation Buttons -->
                        <div class="checkout-navigation d-flex justify-content-between">
                            <a href="{{ route('cart') }}" class="btn btn-outline-secondary"><i class="fa-solid fa-arrow-left me-2"></i>Back to Cart</a>
                            <button type="button" id="continue-to-payment" class="btn btn-primary">Continue to Payment<i class="fa-solid fa-arrow-right ms-2"></i></button>
                            <button type="submit" id="place-order" class="btn btn-success d-none">Place Order<i class="fa-solid fa-check ms-2"></i></button>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 mt-4 mt-lg-0">
                        <!-- Order Summary -->
                        <div class="order-summary card sticky-top" style="top: 20px;">
                            <div class="card-header bg-transparent">
                                <h4 class="mb-0">Order Summary</h4>
                            </div>
                            <div class="card-body">
                                <!-- Order Items -->
                                <div class="order-items mb-3">
                                    <h5 class="mb-3">Items (2)</h5>
                                    
                                    <div class="order-item d-flex mb-3">
                                        <div class="order-item-image me-3">
                                            <img src="{{ asset('assets/img/memento (1).jpg') }}" alt="Roller Blind" class="img-fluid" style="max-width: 60px;">
                                        </div>
                                        <div class="order-item-details flex-grow-1">
                                            <h6 class="mb-0">Premium Roller Blind</h6>
                                            <p class="text-muted small mb-0">White | 120cm x 150cm</p>
                                            <div class="d-flex justify-content-between">
                                                <span class="small">1 x £24.99</span>
                                                <span>£24.99</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="order-item d-flex">
                                        <div class="order-item-image me-3">
                                            <img src="{{ asset('assets/img/premier_bright_white.webp') }}" alt="Venetian Blind" class="img-fluid" style="max-width: 60px;">
                                        </div>
                                        <div class="order-item-details flex-grow-1">
                                            <h6 class="mb-0">Aluminum Venetian Blind</h6>
                                            <p class="text-muted small mb-0">Silver | 90cm x 120cm</p>
                                            <div class="d-flex justify-content-between">
                                                <span class="small">2 x £32.50</span>
                                                <span>£65.00</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <!-- Order Totals -->
                                <div class="order-totals">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Subtotal</span>
                                        <span>£89.99</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Shipping</span>
                                        <span id="shipping-cost">£4.99</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Tax</span>
                                        <span>£18.00</span>
                                    </div>
                                    <hr>
                                    <div class="d-flex justify-content-between mb-0">
                                        <strong>Total</strong>
                                        <strong id="order-total">£112.98</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Secure Checkout Info -->
                        <div class="secure-checkout mt-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title"><i class="fa-solid fa-lock me-2"></i>Secure Checkout</h5>
                                    <p class="card-text small">Your payment information is processed securely. We do not store credit card details nor have access to your credit card information.</p>
                                    <div class="text-center mt-3">
                                        <img src="{{ asset('assets/img/secure-payment.png') }}" alt="Secure Payment" class="img-fluid" style="max-height: 40px;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection