<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Review;
use App\Models\Product;
use App\Models\User;

class ReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = Product::all();
        $users = User::all();
        
        if ($products->isEmpty() || $users->isEmpty()) {
            $this->command->info('No products or users found. Skipping review seeding.');
            return;
        }

        $reviews = [
            ['rating' => 5, 'title' => 'Excellent quality!', 'comment' => 'These blinds are fantastic. Great quality and perfect fit.', 'is_verified' => true],
            ['rating' => 4, 'title' => 'Very good', 'comment' => 'Good quality blinds, easy to install. Recommended.', 'is_verified' => true],
            ['rating' => 5, 'title' => 'Perfect!', 'comment' => 'Exactly what I was looking for. Fast delivery too.', 'is_verified' => false],
            ['rating' => 3, 'title' => 'Decent', 'comment' => 'Good blinds but took a while to arrive.', 'is_verified' => true],
            ['rating' => 4, 'title' => 'Good value', 'comment' => 'Nice blinds for the price. Would buy again.', 'is_verified' => false],
            ['rating' => 5, 'title' => 'Amazing!', 'comment' => 'Best blinds I have ever purchased. Highly recommend!', 'is_verified' => true],
            ['rating' => 4, 'title' => 'Great product', 'comment' => 'Very satisfied with the quality and service.', 'is_verified' => true],
            ['rating' => 2, 'title' => 'Could be better', 'comment' => 'The blinds are okay but not as described.', 'is_verified' => false],
        ];

        foreach ($products->take(10) as $product) {
            $reviewCount = rand(2, 6);
            for ($i = 0; $i < $reviewCount; $i++) {
                $reviewData = $reviews[array_rand($reviews)];
                Review::create([
                    'product_id' => $product->id,
                    'user_id' => $users->random()->id,
                    'rating' => $reviewData['rating'],
                    'title' => $reviewData['title'],
                    'comment' => $reviewData['comment'],
                    'is_verified' => $reviewData['is_verified'],
                ]);
            }
        }

        $this->command->info('Reviews seeded successfully!');
    }
}
