<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\ProductImage;

class ProductImagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = Product::all();
        
        if ($products->isEmpty()) {
            $this->command->info('No products found. Please seed products first.');
            return;
        }

        // Sample blind images
        $blindImages = [
            'assets/images/blinds/blind-1.jpg',
            'assets/images/blinds/blind-2.jpg',
            'assets/images/blinds/blind-3.jpg',
            'assets/images/blinds/blind-4.jpg',
            'assets/images/blinds/blind-5.jpg',
            'assets/images/blinds/blind-6.jpg',
            'assets/images/blinds/blind-7.jpg',
            'assets/images/blinds/blind-8.jpg',
            'assets/images/blinds/blind-9.jpg',
            'assets/images/blinds/blind-10.jpg',
        ];

        foreach ($products as $index => $product) {
            // Add primary image
            ProductImage::create([
                'product_id' => $product->id,
                'image_path' => $blindImages[$index % count($blindImages)],
                'is_primary' => true,
                'sort_order' => 0,
                'alt_text' => $product->name . ' - Main Image'
            ]);

            // Add 2-3 additional images for each product
            $additionalImagesCount = rand(2, 3);
            for ($i = 1; $i <= $additionalImagesCount; $i++) {
                ProductImage::create([
                    'product_id' => $product->id,
                    'image_path' => $blindImages[($index + $i) % count($blindImages)],
                    'is_primary' => false,
                    'sort_order' => $i,
                    'alt_text' => $product->name . ' - Image ' . ($i + 1)
                ]);
            }
        }

        $this->command->info('Product images seeded successfully!');
    }
}
