<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('addresses')) {
    Schema::create('addresses', function (Blueprint $table) {
$table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('label')->nullable();
            $table->text('address');
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('country')->nullable();
            $table->boolean('is_default')->default(false);
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        
    });
}
    }
    public function down() { Schema::dropIfExists('addresses'); }
};
