<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('product_variants')) {
    Schema::create('product_variants', function (Blueprint $table) {
$table->id();
            $table->unsignedBigInteger('product_id');
            $table->string('sku')->nullable();
            $table->decimal('price', 10,2)->nullable();
            $table->integer('stock')->default(0);
            $table->json('options')->nullable();
            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
        
    });
}
    }
    public function down() { Schema::dropIfExists('product_variants'); }
};
