<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('orders')) {
    Schema::create('orders', function (Blueprint $table) {
$table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->decimal('subtotal', 10,2)->default(0);
            $table->decimal('shipping', 10,2)->default(0);
            $table->decimal('tax', 10,2)->default(0);
            $table->decimal('total', 10,2)->default(0);
            $table->string('status')->default('pending');
            $table->string('payment_status')->default('unpaid');
            $table->unsignedBigInteger('coupon_id')->nullable();
            $table->text('shipping_address')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('set null');
        
    });
}
    }
    public function down() { Schema::dropIfExists('orders'); }
};
