<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Filament\Models\Contracts\FilamentUser;
use Filament\Panel;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements FilamentUser
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'role',      // optional
        'is_admin',  // optional boolean
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_admin' => 'boolean',
    ];

    // Filament access control
    public function canAccessPanel(Panel $panel): bool
    {
        // allow access to Filament admin if user has is_admin true OR role === 'admin'
        return (bool) ($this->is_admin ?? ($this->role === 'admin'));
    }

    // alternative older Filament API:
    // public function canAccessFilament(): bool { return (bool) ($this->is_admin ?? ($this->role === 'admin')); }

    // examples of relations
    public function orders() { return $this->hasMany(Order::class); }
}
