<?php
namespace App\Http\Controllers;
use App\Models\ProductImage;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProductImageController extends Controller {
    public function store(Request $r){
        $r->validate(['product_id'=>'required|exists:products,id','image'=>'required|image']);
        $product = Product::findOrFail($r->product_id);
        $path = $r->file('image')->store('products','public');
        $img = ProductImage::create(['product_id'=>$product->id,'path'=>$path,'alt'=>$r->alt ?? null,'is_primary'=>$r->is_primary?1:0]);
        return response()->json($img,201);
    }
    public function destroy($id){
        $img = ProductImage::findOrFail($id);
        Storage::disk('public')->delete($img->path);
        $img->delete();
        return response()->json(null,204);
    }
}
