<?php
namespace App\Http\Controllers;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\CartItem;
use App\Models\Coupon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class OrderController extends Controller {
    public function index(){ $user = Auth::user(); return Order::with('items.product')->where('user_id',$user->id)->paginate(20); }
    public function show($id){ return Order::with('items.product')->findOrFail($id); }

    public function store(Request $r){
        $user = Auth::user();
        $r->validate(['shipping_address'=>'required']);
        $cart = CartItem::with('product')->where('user_id',$user->id)->get();
        if ($cart->isEmpty()) return response()->json(['message'=>'Cart empty'],400);

        $coupon = null;
        if ($r->filled('coupon_code')) {
            $coupon = Coupon::where('code',$r->coupon_code)->first();
            if (!$coupon || !$coupon->isValid()) return response()->json(['message'=>'Invalid coupon'],400);
        }

        return DB::transaction(function() use($user,$cart,$r,$coupon) {
            $subtotal = $cart->reduce(function($carry,$item){ return $carry + ($item->product->price * $item->quantity); }, 0);
            $discount = 0;
            if ($coupon) {
                $discount = $coupon->type === 'percentage' ? ($subtotal * $coupon->value / 100) : $coupon->value;
                $coupon->increment('used_count');
            }
            $shipping = $r->input('shipping', 0);
            $tax = $r->input('tax', 0);
            $total = max(0, $subtotal - $discount + $shipping + $tax);

            $order = Order::create([
                'user_id'=>$user->id,
                'subtotal'=>$subtotal,
                'shipping'=>$shipping,
                'tax'=>$tax,
                'total'=>$total,
                'status'=>'processing',
                'payment_status'=>'unpaid',
                'coupon_id'=>$coupon->id ?? null,
                'shipping_address'=>$r->shipping_address
            ]);

            foreach ($cart as $c) {
                OrderItem::create([
                    'order_id'=>$order->id,
                    'product_id'=>$c->product_id,
                    'quantity'=>$c->quantity,
                    'unit_price'=>$c->product->price,
                    'total_price'=>$c->product->price * $c->quantity,
                    'options'=>null
                ]);
            }

            // clear cart
            CartItem::where('user_id',$user->id)->delete();

            return response()->json($order->load('items.product'),201);
        });
    }
}
