<?php
namespace App\Http\Controllers;
use App\Models\Coupon;
use Illuminate\Http\Request;

class CouponController extends Controller {
    public function index(){ return Coupon::paginate(20); }
    public function show($id){ return Coupon::findOrFail($id); }
    public function store(Request $r){ $data = $r->validate(['code'=>'required|unique:coupons,code','type'=>'required','value'=>'required']); $c = Coupon::create($data); return response()->json($c,201); }
    public function validateCode(Request $r){
        $r->validate(['code'=>'required']);
        $coupon = Coupon::where('code',$r->code)->first();
        if (!$coupon || !$coupon->isValid()) return response()->json(['valid'=>false], 404);
        return response()->json(['valid'=>true,'coupon'=>$coupon]);
    }
    public function update(Request $r,$id){ $c = Coupon::findOrFail($id); $c->update($r->all()); return response()->json($c); }
    public function destroy($id){ Coupon::findOrFail($id)->delete(); return response()->json(null,204); }
}
