<?php
namespace App\Http\Controllers;

use App\Models\Attribute;
use App\Models\AttributeValue;
use Illuminate\Http\Request;
use Illuminate\Support\Str; // ✅ import Str
use Illuminate\Support\Facades\Response; // ✅ for response()->json alternative

class AttributeController extends Controller
{
    public function index()
    {
        return Attribute::with('values')->get();
    }

    public function store(Request $r)
    {
        $data = $r->validate(['name' => 'required']);
        $a = Attribute::create([
            'name' => $data['name'],
            'slug' => Str::slug($data['name']), // ✅ fixed
        ]);

        return Response::json($a, 201);
    }

    public function storeValue(Request $r, $attributeId)
    {
        $a = Attribute::findOrFail($attributeId);
        $v = $a->values()->create($r->validate(['value' => 'required']));

        return Response::json($v, 201);
    }
}
