<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Schemas\Schema;

class ProductInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                // Product Images Section
                RepeatableEntry::make('images')
                    ->label('Product Images')
                    ->schema([
                        ImageEntry::make('image_path')
                            ->label('')
                            ->size(150)
                            ->square()
                            ->defaultImageUrl(url('/images/no-product-image.svg')),
                        TextEntry::make('alt_text')
                            ->label('Alt Text')
                            ->placeholder('No description'),
                        IconEntry::make('is_primary')
                            ->label('Primary')
                            ->boolean()
                            ->trueIcon('heroicon-o-star')
                            ->falseIcon('heroicon-o-star')
                            ->trueColor('warning')
                            ->falseColor('gray'),
                    ])
                    ->columns(3)
                    ->columnSpanFull()
                    ->visible(fn ($record) => $record->images->isNotEmpty())
                    ->placeholder('No images available'),
                
                // Show default image when no images exist
                ImageEntry::make('default_image')
                    ->label('Product Image')
                    ->size(150)
                    ->square()
                    ->url(url('/images/no-product-image.svg'))
                    ->visible(fn ($record) => $record->images->isEmpty())
                    ->columnSpanFull(),
                    
                TextEntry::make('brand.name')
                    ->label('Brand')
                    ->placeholder('-'),
                TextEntry::make('category.name')
                    ->label('Category')
                    ->placeholder('-'),
                TextEntry::make('name'),
                TextEntry::make('slug')
                    ->placeholder('-'),
                TextEntry::make('short_description')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('description')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('price')
                    ->money(),
                TextEntry::make('stock')
                    ->numeric(),
                TextEntry::make('sku')
                    ->label('SKU')
                    ->placeholder('-'),
                IconEntry::make('is_active')
                    ->boolean(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
            ]);
    }
}
